#! /usr/bin/perl -w

#######################
# tcparsestat.pl
# --------------
# read class statistics from tc command line
# convert them from bytes to bits
# store them into a RRD database
# --------------
# j. vehent - 04/2010
#######################
 
use strict;
use RRDs;
 
#use Proc::Daemon;
#Proc::Daemon::Init;
 
my $rrdfile = "/tmp/tcgraph/tcgraph.rrd";
my $logfile = "/tmp/tcgraph/tcgraph.log";
my $updatefreq = 60;
 
while(1)
{
        # define list of classes to check with default value = 'U'
        # ('U' means unknown in RRD tool langage)
        my %classlist=(
           1 => 'U',
           2 => 'U',
	   3 => 'U',
           111 => 'U',
           112 => 'U',
           113 => 'U',
           114 => 'U'
           );
 
        my %valuelist = %classlist;
 
        # get statistics from command line
        open(TCSTAT,"tc -s class show dev ath0 |") || die "could not open tc command line";
                
        # look for specified classes into command line result
        while(<TCSTAT>)
        {
           chomp $_;
           # do we have class information in this line ?
           foreach my $class (keys %classlist)
           {
              if ($_ =~ /\:$class parent/)
              {
                 # If yes, go to the next line and get the Sent value
                 my $nextline = <TCSTAT>;
 
                 my @splitline = split(/ /,$nextline);
 
                 # multiplicate by 8 to store bits and not bytes, and store it
                 $valuelist{$class} = $splitline[2]*8;
 
                 # do not check this specific class for this time
                 delete $classlist{$class};
              }
           }
        }
 
        my $thissecond = time();
 
        # update line is :
        # <unix time>:<statistic #1>:...:<statistic #n>
        my $updateline = time().":$valuelist{'1'}:$valuelist{'2'}:$valuelist{'3'}:$valuelist{'111'}:$valuelist{'112'}:$valuelist{'113'}:$valuelist{'114'}";
        #system("rrdtool update $rrdfile $updateline");
	RRDs::update $rrdfile, "$updateline";
 
        if (defined $logfile)
        {
           open(TCGLOG,">>$logfile");
           print TCGLOG "$updateline\n";
           close TCGLOG;
        }
 
        close TCSTAT;
 
        # sleep until next period
        sleep $updatefreq;
}

